Code for our paper on improving adversarial robustness using proxy distribution.

## Getting started

Let's start by installing following dependencies: `scikit_image, numpy, torch, torchvision, autoattack`

## Training a model
Training a model is very straightforward. Just use a variation of this command.

`CUDA_VISIBLE_DEVICES=4,5,6,7 python -m torch.distributed.launch --nproc_per_node=4 train.py --accelerator ddp --fp16 --configs configs/configs_cifar10.yml --trainer madry --val-method adv --print-freq 20 --arch resnet18 --exp-name resnet18_baseline`

`CUDA_VISIBLE_DEVICES=4,5,6,7 python -m torch.distributed.launch --nproc_per_node=4 train.py --accelerator ddp --fp16 --configs configs/configs_cifar10.yml --trainer madry --val-method adv --print-freq 20 --arch resnet18 --syn-data-list ddpm --exp-name resnet18_ddpm`

Unfortunately we are unable to share the synthetic samples in an anonymized manner (because the total file size is ~20GB). So it may not be feasible to train the models with synthetic samples on your end. 

## Evaluating a model
`CUDA_VISIBLE_DEVICES=4,5,6,7 python -m torch.distributed.launch --nproc_per_node=4 eval.py --configs configs/configs_cifar10.yml --val-method auto --print-freq 20 --arch resnet18 --ckpt ./trained_models/resnet18_ddpm_robust.tar  --exp-name resnet18_ddpm_eval`